-- Settings
Z = 22 
Valence = 4 
dir = "."
dofile(dir.."/input/FunctionsMarc.Quanty")
NB = 0 


ClosedOrbitalLabels = {"1s1/2","2s1/2","2p1/2","2p3/2","3s1/2","3p1/2","3p3/2"}
OpenOrbitalLabels   = {"3d3/2","3d5/2","4p1/2","4p3/2"}
ExcitedOrbitalLabels= {}
EmptyOrbitalLabels  = {} 

Indices = GenerateIndices(ClosedOrbitalLabels,OpenOrbitalLabels,ExcitedOrbitalLabels,EmptyOrbitalLabels,Z,Valence)

KeepConstantInCalculation   = Flatten({Indices["Dict"]["2s1/2"],Indices["Dict"]["3s1/2"],Indices["Dict"]["2p1/2"],Indices["Dict"]["2p3/2"],Indices["Dict"]["3p1/2"],Indices["Dict"]["3p3/2"]})
KeepConstantInCalculation[#KeepConstantInCalculation + 1] = Indices["Dict"]["1s1/2"]
KeepConstantInCalculation[#KeepConstantInCalculation + 1] = Flatten({Indices["Dict"]["3d3/2"],Indices["Dict"]["3d5/2"]})
KeepConstantInCalculation[#KeepConstantInCalculation + 1] = Flatten({Indices["Dict"]["4p1/2"],Indices["Dict"]["4p3/2"]})

-- Angular momentum & number operators
Jops = CreateAngularMomentumOperators(Indices.Labels, Indices.All, Indices.NF)
Nops = CreateNumberOperators(Indices.Labels, Indices.All, Indices.NF)

-- G (F) is the large (small) component of the Dirac spinor which solves the (relativistic) Kohn-Sham equations
G, F, x = ReadFPLOBasisFunctions(Indices.Labels,dir.."/input/Ti4+fval.001.1",dir.."/input/Ti4+fval.001.2")                                      

print()
print("====================================================================================")
print("=========================  Hamiltonian & ground state  =============================")
print("====================================================================================")
print()

-- Kinetic energy described by Dirac's Hamiltonian & Coulomb interaction
H0    = NewOperator("Dirac",Indices.NF,Indices.Z, Indices.All,G,F)
UFull = NewOperator("AtomicU",Indices.NF, Indices.All,G,F)

-- The total Hamiltonian is given by the sum of Dirac and Coulomb part 
H = (H0 + UFull) * EnergyUnits.Ha.value 

-- Reduce the number of terms in the Hamiltonian by taking out scattering terms between orbitals or shells that do not change their occupation
H = PartialOperator(H, KeepConstantInCalculation, "conserve")

-- The crystal field in SrTiO3 is cubic and acts on the 3d shell. We expand the crystal field potential on spherical 
-- harmonics and afterwards rotate to a (j,jz)-basis. The crystal field splitting is characterised by the paramater 
-- 'tenDq'.

IndexUp_3d = {19,21,23,25,27}
IndexDn_3d = {18,20,22,24,26}

YtJ   = YtojjzMatrix(2)
Id1   = Matrix.Identity(Indices.NF-16)
Id2   = Matrix.Identity(6)

ULtoJ = Matrix.Flatten({{Id1,0,0},{0,YtJ,0},{0,0,Id2}})

Akm      = PotentialExpandedOnClm("Oh", 2, {0.6,-0.4})
OpptenDq = Rotate(NewOperator("CF", Indices.NF, IndexUp_3d, IndexDn_3d, Akm),ULtoJ)
tenDq    = 2.6

H = H + OpptenDq
H = (H + ConjugateTranspose(H))/2


-- Restrictions imposed on ground state
GroundRestrictions = {Indices.NF, 0, 
  					 {"1111111111111111111111111111111111",18, 18},
  					 {"1111111111111111110000000000000000",18, 18}}				
  					

psi0 = Chop(Eigensystem(H,GroundRestrictions,1,{{"Restrictions",GroundRestrictions},{"denseborder",0}})) 
E0 	 = Braket(psi0,H,psi0)

-- shift Hamiltonian by ground state energy
H    = H - E0

print()
print("====================================================================================")
print("==========================  States accessible in XAS   =============================")
print("====================================================================================")
print()

TimeStart("Determine states accessible in XAS")

YtJ   = YtojjzMatrix(1)
Id    = Matrix.Identity(Indices.NF-6)
ULtoJ = Matrix.Flatten({{Id,0},{0,YtJ}})

IndexUp_4p = {29,31,33}
IndexDn_4p = {28,30,32}
IndexUp_1s = {1}
IndexDn_1s = {0}

Akm = {{1,-1,sqrt(1/2)},{1, 1,-sqrt(1/2)}}
TXASx = Rotate(NewOperator("CF", Indices.NF, IndexUp_4p, IndexDn_4p, IndexUp_1s, IndexDn_1s, Akm),ULtoJ)
Akm = {{1,-1,sqrt(1/2)*I},{1, 1,sqrt(1/2)*I}}
TXASy = Rotate(NewOperator("CF", Indices.NF, IndexUp_4p, IndexDn_4p, IndexUp_1s, IndexDn_1s, Akm),ULtoJ)
Akm = {{1,0,1}}
TXASz = Rotate(NewOperator("CF", Indices.NF, IndexUp_4p, IndexDn_4p, IndexUp_1s, IndexDn_1s, Akm),ULtoJ)

TXASr =  sqrt(1/2) * (TXASx - I * TXASy)
TXASl = -sqrt(1/2) * (TXASx + I * TXASy)

-- The final states we want to determine are characterised by a core hole in the 1s shell and one additional
-- electron in the 4p. The corresponding restrictions are: 
XAS_Restrictions = { Indices.NF , 0 ,
				   {"1111111111111111111111111111111111", 18, 18},
				   {"1100000000000000000000000000000000",  0,  1},  
  				   {"0011111111111111110000000000000000", 16, 16},
  				   {"0000000000000000001111111111000000",  0,  0},
  				   {"0000000000000000000000000000111111",  0,  1}}

Ntri_XAS = 2
spec_XAS, tri_XAS, bas_XAS = CreateSpectra(H,TXASx,psi0,{{"E0",E0},{"Emin",0},{"Emax",2},{"NE",3},{"Gamma",1},{"Tensor",true},{"Restrictions",XAS_Restrictions},{"epsilon",1e-5},{"NTri",Ntri_XAS},{"KrylovBasis",true},{"DenseBorder",0}})

-- Ensure that Krylov states are orthonormal
bas_XAS = Simon.Flatten(bas_XAS)
bas_XAS = Orthonormalize(bas_XAS,{{"SingularValue",1E-10}})

-- Diagonalise Krylov Hamiltonian
KryHam_XAS = Braket(bas_XAS,H,bas_XAS) 
eVals_XAS, eVecs_XAS = Eigensystem(KryHam_XAS)

-- Rotate to eigenbasis
phi_XAS = Martin.BasisChange(bas_XAS,eVecs_XAS)

ExpectationValues(phi_XAS,H,0,Jops,Nops,Indices.Labels)

TimeEnd("Determine states accessible in XAS")

print()
print("====================================================================================")
print("====================  Calculate fluorescence self-energy  ==========================")
print("====================================================================================")
print()

TimeStart("Calculate fluorescence self-energy") 

-- A core-excited state, for example a state with core hole in 1s and one electron excited into the 4p, is not an 
-- eigenstate of the (full) Hamiltonian. Such a state can couple to the EM field and thereby interact with states 
-- containing one additional photon. Here were only allow the core hole to decay via electric dipole (E1) transitions. 


-- Import radial integrals given on a grid with spacing dw=10eV
dofile(dir.."/input/radial_ints_Kedge_E1.Quanty")

-- Determine angular part of the E1 transition operator 
dofile(dir.."/input/CreateElectricMultipoleOp.lua")
CreateElectricMultipoleOp(Indices.Labels,RadialIntegrals)


-- Determine all states accessible after fluorescence decay of the 1s core hole. We use the Lanczos 
-- method to span the Krylov space governed by the restrictions:
FY_Restrictions = {Indices.NF, NB, 
  				  {"1111111111111111111111111111111111", 18, 18},
  				  {"1111111111111111110000000000000000", 17, 18}, 
  				  {"0000000000000000001111111111000000",  0,  0}, 
  				  {"0000000000000000000000000000111111",  0,  1}}


-- list of possible E1 transitions 
E1Transitions = {}
for i = 1, #OpList do
	E1Transitions[i] = OpList[i][2]
end

Ntri_FY = 18
spec_FY, tri_FY, bas_FY = CreateSpectra(H, E1Transitions, TXASx*psi0, {{"Emin",0}, {"Emax",1}, {"NE",2}, {"Gamma",1}, {"NTri",Ntri_FY}, {"E0",E0}, {"KrylovBasis",true},{"Restrictions",FY_Restrictions},{"epsilon",1e-5}, {"Tensor",true},{"DenseBorder",0}}) 

-- Ensure that Krylov states are orthonormal
bas_FY = Simon.Flatten(bas_FY)
bas_FY = Orthonormalize(bas_FY,{{"SingularValue",1e-10}})

-- Diagonalize the Krylov Hamiltonian
KryHam_FY = Braket(bas_FY,H,bas_FY) 
eVals_FY, eVecs_FY = Eigensystem(KryHam_FY)

-- Eigenstates with eigenenergies below the energy of the L-edge
eVecsL_FY = {}
eValsL_FY = {}
for i = 1, #eVals_FY do
	if eVals_FY[i] > 1e-10 then
		eVecsL_FY[#eVecsL_FY+1] = eVecs_FY[i]
		eValsL_FY[#eValsL_FY+1] = eVals_FY[i]
	end
end

-- Rotate to eigenbasis
phi_FY = Martin.BasisChange(bas_FY, eVecsL_FY)
ExpectationValues(phi_FY,H,0,Jops,Nops,Indices.Labels)

-- Write final states (accessible in XAS) & eigenstates after fluorescence decay in one list
phi  = Join(phi_XAS,phi_FY)

-- ...and express the E1 transition operators in terms of matrices
OpMats = {}
for i = 1, #OpList do
	OpMats[i] = {Braket(phi,OpList[i][1],phi),Braket(phi,OpList[i][2],phi)}
end

-- Interpolate radial integrals
RadInt_List = {}
for OpIndex = 1, #RadialIntegrals do
	w_p_List      = {}
	RadInt_List11 = {} 
	RadInt_List12 = {}
	for k = 1, #RadialIntegrals[1][8] do
		w_p_List[#w_p_List+1]           = RadialIntegrals[OpIndex][8][k][1]
		RadInt_List11[#RadInt_List11+1] = RadialIntegrals[OpIndex][8][k][3]
		RadInt_List12[#RadInt_List12+1] = RadialIntegrals[OpIndex][8][k][4]	
	end
	R11 = InterpolatingFunction.Spline(w_p_List,RadInt_List11)
	R12 = InterpolatingFunction.Spline(w_p_List,RadInt_List12)
	RadInt_List[#RadInt_List+1] = {R11, R12}
end


-- Settings for self-energy
wMin = 5020 
wMax = 5035
dw   = 0.2
Nw   = floor((wMax-wMin)/dw) + 1

dofile(dir.."/input/CalculateFluorescenceSEmatrix.lua")
CalculateFluorescenceSEmatrix(wMin,wMax,dw,#phi_XAS,eValsL_FY,OpMats,RadInt_List)


-- Interpolate self-energies
wList = {}
for i = 1, Nw do
	wList[i] = wMin+(i-1)*dw
end

sigmaFY = {}
for i = 1, #ImSigma_w[1] do
sigmaFY[i] = {}
	for j = 1, #ImSigma_w[1] do
		sigmaYvals = {}
		for wInd = 1, #wList do
			sigmaYvals[#sigmaYvals+1] = ImSigma_w[wInd][i][j]
		end
		sigmaFY[i][j] = InterpolatingFunction.Spline(wList,sigmaYvals)
	end
end
-- sigmaFY is the self-energy matrix where each matrix element is given by an interpolation function 

TimeEnd("Calculate fluorescence self-energy") 

print()
print("====================================================================================")
print("=========================  XAS with FY self-energy  ================================")
print("====================================================================================")
print()

-- XAS spectrum using the calculated fluorescence self-energy to describe the broadening. We neglect 
-- off-diagonal elements of the self-energy matrix to keep the calculation fast.   

dw_XAS = 1e-3
Nw_XAS = floor((wMax-wMin)/dw_XAS) + 1

TimeStart("Calculate XAS")
XAS = {}
for i = 1, Nw_XAS do
    w = wMin + (i-1) * dw_XAS
    M = Matrix.Zero(#phi_XAS)
    for j = 1, #M do
        M[j][j] = -w + I * sigmaFY[j][j](w) + eVals_XAS[j] 
    end
    R = Matrix.Inverse(M)
    XAS[i] = {w,0}
	for k = 1, #R do
        --for l = 1, #R do   	
            --XAS[i][2] = XAS[i][2] + Complex.Im(R[k][l]) * Braket(TXASx*psi0,phi_XAS[k]) * Braket(phi_XAS[l],TXASx*psi0)
            XAS[i][2] = XAS[i][2] + Complex.Im(R[k][k]) * Braket(TXASx*psi0,phi_XAS[k]) * Braket(phi_XAS[k],TXASx*psi0)
        --end
    end
end
TimeEnd("Calculate XAS")


-- Save output
file = io.open(dir.."/output/SrTiO3_XAS_K-edge.dat","w")
io.output(file)

for i = 1, #XAS do
   io.write(XAS[i][1],"\t",XAS[i][2],"\n")
end
io.close(file)



TimePrint()























