# -- mode: PYTHON --

# probably superfluous, just for demonstration
# it would be easier to load the file two times

killall()

g1=G[1]

# read the data
ret=g1.read("bandweight",'+bweights')

# dont show spin down
ret[1].group.off()  # use 'read' return value, we know there are two groups
gr1=ret[0].group    # but we do not need to know their ids

# make a new graph
g2=G[2].on()
gr2=g2.Gr.new().on() # we need not know the Group.id

# copy sets of spin down
for s in gr1.S: gr2.S.append(s)
# setup weight-data
gr2.unifyWeightLabels()

# copy world
g2.world.y=g1.world.y

# make the group decide style
gr2.useattributes=1
# dont show legend entry for the bands
gr2.showinlegend=0


#copy special symmetry points
for u in g1.usertics: g2.usertics.append(u)
for u in gr1.usertics: gr2.usertics.append(u)
# let the upper graphs labels vanish
for t in gr1.usertics: t.labelside='none'
gr2.usertics.on()
g2.xtics.side='none'
g2.xtics.labels.side='none'


#arrange them
arrange(600,Nx=1,Ny=2,commonxaxis=1,commonyaxis=1,vgap=0.04,leftgap=0.17)

# setup weights for both
for g in [gr1,gr2]:
    g.W[1].off()
    g.W[5].name='4s' # an example for setting weight names
    g.setWeightsStyle(style='individual',factor=1,min=0.2,max=6,
        showinlegend=True)

    cols=[0xaa00,0xee0000,0xff,0xffaa00,0xff00aa,0xffff]
    for id ,col in zip([5,7,8,9,10,11],cols):
        g.W[id].on()
        g.W[id].setStyle(style='circle',color=col,skip=5,linewidth=2,fill=0)




g1.title.text="Fat bands, bcc-Fe"
g2.xaxislabel.off()
g2.yaxislabel.text=g1.yaxislabel.text
g2.legend.off()

# inserted from the menu
Legend(1).on()\
  .setText(font=FontStyle(size=10,subscriptscale=0.75,color=0x0),
    linespacing=0.2)\
  .setSymbol(spacing=0.5,width=3)\
  .setFrame(Frame(active=1,borderspacing=0.4,
      rim=LineStyle(style='Solid',width=1,color=0x0,extracolor=True),
      fill=FillStyle(active=True,color=0xffffff,extracolor=True)))\
  .setGeometry(position=(1.07421,-0.0983383),origin=(1,0))



