# -- mode: PYTHON --
killall  ()
g=G[1]
gr=g.Gr[1]

# make raw data

s=gr.S[1].on()
s.x=[0,1,2,3]
s.y=[0,1,4,5]
s.legend="raw data"   
s.line.color=0xf00   
s.line.style='None'
s.symbol.style='o'
s.symbol.fill.active=1

# make splines

N=100   
m=Vector(N,-1,4) 

cols=[0xff0000 ,0xcc00,0xff]

for id in [2,3,4]:
    gr.S.append(s)
    ss=gr.S[id]
    ss.bspline(id-1,0,m)
    ss.legend='spline order {0}'.format(id-1)
    ss.line.color=cols[id-2]

g.world.offset=(0.05,0.05)
g.autoscale()

g.title.text='B-spline example'
g.xaxislabel.text='x'
g.xaxislabel.restriction=('y',0)
g.yaxislabel.text='y'
g.yaxislabel.restriction=('x',0)

g.legend.frame.off()
g.legend.position=(0.9,0.5)


arrange(paperwidth=600,Nx=1,leftgap=0.15,rightgap=0.05,
    hgap=0.1,Ny=1,topgap=0.166,bottomgap=0.19,vgap=0.1,
    aspectratio=1.48292, commonxaxis=True,commonyaxis=True,
    commontitle=True)
