# -- mode: PYTHON --
import numpy as np

killall()
g=G[1]
gr=g.Gr[1].on()
N=1000
a=0.5
x0=-0.6
x1=1.6
w=0.2
s=gr.S[1].on()
# s1 length N
s.x=Vector(N,x0,x1)
s.y=np.exp(-((s.x-a)/w)**2/2)*3
m1=s.moment(1,[x0,x1])
m2=s.moment(2,[x0,x1])
# calculate the normalized width
wi=np.sqrt(m2-m1**2)
t=g.textboxes.new()
t.text='calculated width={} input width={}'.format(wi,w)

gr.usertics.on()
gr.usertics.append(Tic(type='xmajor',position=m1,label='m1',
        labelside='Opposite',length=1,line=LineStyle(style='Solid')))\
    .append(Tic(type='xmajor',position=m1+wi,label='wi',
        labelside='Opposite',length=1,line=LineStyle(style='Dash')))\
    .append(Tic(type='xmajor',position=m1-wi,label='wi',
        labelside='Opposite',length=1,line=LineStyle(style='Dash')))



g.title.text='Moment example'
g.title.restriction=('y',0.02)
g.autoscale()