#! /usr/bin/env python3
# ===================================================================
# file:   extractbasdeffromout.py
# author: k.koepernik@ifw-dresden.de
# date:   24 Jun 2022

from __future__ import print_function
import sys
import numpy as np

# ===================================================================
# 
# ===================================================================
def extractBasDefFromOut(outfile='out',basdeffile='=.basdef'):
    
    with open(outfile,'r') as fh:
        lines=fh.readlines()

    with open(basdeffile,'w') as fh:
        start=False
        for line in lines:
            if line.startswith('Start: content of =.basdef'):
                start=True
                continue
            if line.startswith('End  : content of =.basdef'):
                break
            if start:
                if line.startswith('---'): continue
                fh.write(line)
    return

# ===================================================================
# 
# ===================================================================

if __name__ == '__main__':

    extractBasDefFromOut(outfile='out',basdeffile='=.basdef')
    
    sys.exit(0)




