kill all

graph point size scale 1.5

w=1050
h=600
paper size w,h
vx0=0.1
dvx=0.51
vy0=0.2
vh=0.65
# For a square view, it must hold that the absolute sizes fulfill vw*w=vh*h
vw=vh*h/w

E0=-1270.5846*1
E0G=-1272.8056*1
fac=2000*1+0

with g1
view vx0,vy0,vw,vh

title on
  title "Fe LDA vs GGA"
  title font size 20
  title font subscriptscale 0.75
  title font color 0x0
  title frame on
  title frame rim style solid
  title frame rim width 1
  title frame rim color 0xffffff
  title frame fill on
  title frame fill color 0xffffff
  title frame border spacing 0.2
  title coordinate system View
  title position 1.12889 , -0.143974
  title angle 0
  title origin 0.5 , 1
  title restriction none
  title restriction additional 1 2 9 10

yaxislabel "energy [mRy]"
xaxislabel "volume [a$_B$.$x{-0.6}$y{-0.4}$^3$.]"

read xny "lda/bcc/SP/e"
g1.gr1.s1 legend "LDA, bcc, FM"
y=(y-E0)*fac
N=100   
m=mesh(x[0],x[s1.length-1],N)  
bspline(s1,2,0,m)
line width 2
line color 0x0
line style dash


read xny "lda/bcc/NSP/e" into gr1
s2 legend "LDA, bcc, NM"
y=(y-E0)*fac
m=mesh(x[0],x[s1.length-1],N)  
bspline(s2,2,0,m)
line width 2
line color 0xff0000
line style dash


read xny "lda/fcc/NSP/e" into gr1
s3 legend "LDA, fcc, NM"
y=(y-E0)*fac
m=mesh(x[0],x[s1.length-1],N)  
bspline(s3,2,0,m)
line width 2
line color 0xcc00
line style dash

read xny "gga/bcc/SP/e" into gr1
s4 legend "GGA, bcc, FM"
y=(y-E0G)*fac
m=mesh(x[0],x[s1.length-1],N)  
bspline(s4,2,0,m)
line width 2
line color 0x0

read xny "gga/bcc/NSP/e" into gr1
s5 legend "GGA, bcc, NM"
y=(y-E0G)*fac
m=mesh(x[0],x[s1.length-1],N)  
bspline(s5,2,0,m)
line width 2
line color 0xff0000


read xny "gga/fcc/NSP/e" into gr1
s6 legend "GGA, fcc, NM"
y=(y-E0G)*fac
m=mesh(x[0],x[s1.length-1],N)  
bspline(s6,2,0,m)
line width 2
line color 0xcc00


autoscale

world x 63,87
world y -5,70


# legend box
legend on
  legend font size 8
  legend font subscriptscale 0.75
  legend font color 0x0
  legend line spacing 0
  legend symbol marker spacing 0.5
  legend symbol marker width 2
  legend frame on
  legend frame rim style solid
  legend frame rim width 1
  legend frame rim color 0x0
  legend frame border spacing 0.3
  legend frame fill on
  legend frame fill color 0xffffff
  legend position 0.635822 , -0.132845
  legend origin 1 , 0


####################################
# graph 2
####################################



g2 on
graph point size scale 1.5
vx0=vx0+dvx
view vx0,vy0,vw,vh
title off
yaxislabel "moment [$~m$_B$.]"
yaxislabel  frame fill off
xaxislabel "volume [a$_B$.$x{-0.6}$y{-0.4}$^3$.]"


read xny "lda/bcc/SP/s"
g2.gr1.s1 legend "LDA, bcc, FM"
N=100   
m=mesh(x[0],x[s1.length-1],N)  
bspline(s1,2,0,m)
line width 2
line color 0x0
line style dash

read xny "gga/bcc/SP/s" into gr1
s2 legend "GGA, bcc, FM"
N=100   
m=mesh(x[0],x[s1.length-1],N)  
bspline(s2,2,0,m)
line width 2
line color 0x0

# legend box
legend on
  legend font size 8
  legend font subscriptscale 0.75
  legend font color 0x0
  legend line spacing 0
  legend symbol marker spacing 0.5
  legend symbol marker width 2
  legend frame on
  legend frame rim style solid
  legend frame rim width 1
  legend frame rim color 0x0
  legend frame border spacing 0.3
  legend frame fill on
  legend frame fill color 0xffffff
  legend position 0.687743 , 0.0461324
  legend origin 1 , 0


autoscale
world x 63,87



