killall()


E0=-1270.5846*1
E0G=-1272.8056*1
fac=2000*1+0

#============================================================
def load(g,file,leg,col,lst,E0=E0,fac=fac):
    ret=g.read('xny',file)[0]
    s=ret.sets[0]
    s.legend=leg
    s.line.width=2
    s.line.color=col
    s.line.style=lst
    s.y=(s.y-E0)*fac

    N=100   
    s.bspline(2,0,Vector(N,s.x[0],s.x[-1]))

    g.legend.font.size=8
    g.legend.linespacing=0
    g.legend.symbolspacing=0.5
    g.legend.symbolwidth=2
    g.legend.frame.borderspacing=0.3

#============================================================


g=G[1]

g.title.on()
g.title.text='Fe LDA vs GGA'
g.title.font.size=20

g.title.position=(1.12889 , -0.143974)
g.title.restriction=None
g.title.offsets=[1 ,2 ,9 ,10]

g.yaxislabel.text='energy [mRy]'
g.xaxislabel.text='volume [a$_B$.$x{-0.6}$y{-0.4}$^3$.]'

load(g,"lda/bcc/SP/e",'LDA, bcc, FM',0x0,'Dash')
load(g,"lda/bcc/NSP/e",'LDA, bcc, NM',0xcc0000,'Dash')
load(g,"lda/fcc/NSP/e",'LDA, fcc, NM',0xcc00,'Dash')

load(g,"gga/bcc/SP/e",'GGA, bcc, FM',0x0,'Solid',E0G)
load(g,"gga/bcc/NSP/e",'GGA, bcc, NM',0xcc0000,'Solid',E0G)
load(g,"gga/fcc/NSP/e",'GGA, fcc, NM',0xcc00,'Solid',E0G)
g.autoscale()

g.world.x=(63,87)
g.world.y=(-5,70)


g.legend.position=(0.635822 , -0.132845)

#####################################
## graph 2
#####################################
#
#
#
g=G[2].on()
g.title.off()
g.yaxislabel.off()
g.oppositeyaxislabel.on().text='moment [$~m$_B$.]'
g.xaxislabel.text='volume [a$_B$.$x{-0.6}$y{-0.4}$^3$.]'


load(g,'lda/bcc/SP/s','LDA, bcc, FM',0x0,'Dash',0,1)
load(g,'gga/bcc/SP/s','GGA, bcc, FM',0x0,'Solid',0,1)


g.legend.position=(0.687743 , 0.0461324)


g.autoscale()
g.world.x=(63,87)



arrange(paperwidth=700,Nx=2,leftgap=0.12,rightgap=0.1,
    hgap=0.3,Ny=1,topgap=0.2,bottomgap=0.2,vgap=0.1,
    aspectratio=1, commonxaxis=True,commonyaxis=False,
    commontitle=True)
