#! /usr/bin/env python

from __future__ import print_function
import sys,os

# If your pyfplo is not found you could also
# explicitly specify the pyfplo version path:
#sys.path.insert(0,"/home/magru/FPLO/FPLO22.00-62/PYTHON/doc");

import numpy as np
import numpy.linalg as LA
import pyfplo.slabify as sla
import pyfplo.fploio as fploio
import pyfplo.common as com


print( '\npyfplo version=: {0}\nfrom: {1}\n'.format(sla.version,sla.__file__))
# protect against wrong version
#if fedit.version!='22.00': raise RuntimeError('pyfplo version is incorrect.')


# ===================================================================
# 
# ===================================================================

def ndprint(a, prec=5,supsmall=True,maxwidth=75):
    return np.array_str(a,suppress_small=supsmall,
                     precision=prec,max_line_width=maxwidth)


# ===================================================================
# 
# ===================================================================

def work():

    # prepare Slabify
    hamdata='../../+hamdata'
    
    s=sla.Slabify()
    s.object='3d'
    s.printStructureSettings()
    s.prepare(hamdata)

    s.calculateMirrorChernNumbers(homo=10,nint=40)
    
    print( 'done')
    return



# ===================================================================
# 
# ===================================================================


if __name__ == '__main__':

    work()

