#! /usr/bin/env python
# ===================================================================
# file:   auto.py
# author: k.koepernik@ifw-dresden.de
# date:   19 Jun 2017
from __future__ import print_function
import sys
import numpy as np
import numpy.linalg as LA

import pyfplo.slabify as sla

print('\npyfplo version=: {0}\nfrom: {1}\n'.format(sla.version,sla.__file__))




# ===================================================================
# 
# ===================================================================
def work(iwp):


    hamdata='../../+hamdata'
    s=sla.Slabify()
    s.object='3d'
    s.prepare(hamdata)

    try:
        from weylpoints import wps
    except:
        raise RuntimeError('file weylpoints.py does not exist')
    
    wp=wps[iwp]
    s.calculateChernNumberInSphere(center=wp.k,
                                   radius=wp.radius,homo=wp.homo,
                                   nsubdiv=10,nradius=1)

    return
  
 
 
# ===================================================================
# 
# ===================================================================

if __name__ == '__main__':

    
    if len(sys.argv)>1 and sys.argv[1]=='-h':
        print("usage: {} [-h] -i wp-number".format(sys.argv[0]))
        sys.exit(0)
    try:
        i=int(sys.argv.index("-i"))
        iwp=int(sys.argv[i+1])
    except:
        raise RuntimeError('need option -i wp-number')


    work(iwp)
    
    sys.exit(0)




