#! /usr/bin/env python
from __future__ import print_function
import sys

# If your pyfplo is not found you could also
# explicitly specify the pyfplo version path:
#sys.path.insert(0,"/home/magru/FPLO/FPLO22.00-62/PYTHON/doc");

import numpy as np
import pyfplo.slabify as sla


print( '\npyfplo version=: {0}\nfrom: {1}\n'.format(sla.version,sla.__file__))
# protect against wrong version
#if fedit.version!='22.00': raise RuntimeError('pyfplo version is incorrect.')


# ===================================================================
# 
# ===================================================================

def work():


    hamdata='../+hamdata'
    
    s=sla.Slabify()


    s.object='slab'
    s.enlarge=[ [1,1,0],[-1,1,0],[0,0,1]]
    s.anchor=-0.001
    s.numberoflayers=10
    s.printStructureSettings()

    s.prepare(hamdata)
    
    bp=sla.BandPlot()
    bp.points=[
        ['$~G',[0,0,0]],
        ['X',[0.5,0,0]],
        ['M',[0.5,0.5,0]],
        ['$~G',[0,0,0]],
        ]
    bp.calculateBandPlotMesh(s.dirname)
    
    s.calculateBandStructure(bp);



    # all orbital indices up to 10 length units at the upper surface
    iupper=s.orbitalIndicesByDepth(-1,10)
    # all orbital indices up to 10 length units at the lower surface
    ilower=s.orbitalIndicesByDepth(10,-1)
    # get all orbital indices
    iall=s.orbitalIndicesByDepth()
    # a nice python trick to get the rest list
    irest=list(set(iall)-set(iupper)-set(ilower))

    print( 'the orbital indices lists:',ilower,irest,iupper)
    

    
    
    wds=sla.WeightDefinitions()
    wds.add('bulk').addLabels(s.orbitalNames(irest))
    wds.add('lower').addLabels(s.orbitalNames(ilower))
    wds.add('upper').addLabels(s.orbitalNames(iupper))

    bw=sla.BandWeights(s.dirname+'/+bweights_sf')
    bw.addWeights(wds,s.dirname+'/+bwsum_sf')




# ===================================================================
# 
# ===================================================================


if __name__ == '__main__':

    work()

