#! /usr/bin/env python

import sys
import numpy as np


wandefheader='''
doit

---- real space grid for pictures of WFs ---------------------

WF_grid_basis conv prim
WF_grid_directions      2   0   0 
                        0   2   0
                        0   0   2 



WF_grid_subdivision  30 30 30

#WF_grid_origin       -0.5 -0.5 -0.5





-------------------------------------------------

ham_cutoff 15
WF_ham_threshold 0.001

WF_coeff_threshold 0.001

WF_write_coeff_stats on
ham_write_t_stats on


----- ham export grid --------

k_grid_basis prim
k_grid_directions       1 0 0 
                        0 1 0
                        0 0 1
k_grid_subdivision  1 1 1
k_grid_incl_periodic_points off

'''

wanheader='''
------------------------------------------------------------------------
wandef
    {0}
    name {1}
    emin {2} {2}
    emax {3} {3}
    de {4} {4}
    delower {5} {5}
    deupper {6} {6}
'''

contrib='''\
    contrib
        site {0}
        difvec {1}
        xaxis {2}
        zaxis {3}
        orb {4}
        fac {5}
'''

# -------------------------------------------------------------------
def vector_to_string(m):
    return ' '.join([str(xx) for xx in m.tolist()[0]])

# ===================================================================
def main():
    s=np.sqrt(3.)/2.

    # lattice constants in Bohr radii
    a0=5.816577012730269
    c0=6.712307195977232

    # lattice vectors
    A=np.matrix([[a0*s,-a0*0.5,0],[0,a0,0,],[0,0,c0]],dtype='float')

    # operations
    C6=np.matrix([[0.5,-s,0],[s,0.5,0,],[0,0,1]],dtype='float')
    C3=C6.dot(C6)
    C2_90=np.matrix([[-1,0,0],[0,1,0,],[0,0,-1]],dtype='float')
    s_0=np.matrix([[-1,0,0],[0,1,0,],[0,0,1]],dtype='float')
    
    # sites
    sB2=np.matrix([1./3,2./3,0.5],dtype='float').dot(A)
    sB3=sB2.dot(C6)



    #print 'sB2=',sB2
    #print 'sB3_s_0=',sB2.dot(s_0)
    #print 'C2_90=',C2_90
    #print 's_0=',s_0
    #print 'c=',c

    E=np.identity(3)

    emin=-13
    emax=-5
    delower=1
    deupper=1




    xaxiss=np.matrix([1,0,0],dtype='float')
    zaxis=np.matrix([0,0,1],dtype='float')
    difvec=np.matrix([0,0,0],dtype='float')

    wandefs=''
    for fac in xrange(1,-3,-2):
        sB3=sB2.dot(C6)
        xaxisp=xaxiss.dot(C3.T)
        for i in xrange(1,4):

            c=(sB2+sB3)*0.5
            #print 'sB2=',sB2
            #print 'sB3=',sB3
            #print 'c=',c            

            
            if fac>0:
                nameb='B'
                onoff='on'
                emin=-15
                emax=0
                delower=1
                deupper=1
            else:
                nameb='AB'
                onoff='off'
                emin=8
                emax=8.1
                delower=8
                deupper=10

            txt=wanheader.format(onoff,'B {1}sp{0} '.format(i,nameb),
                                 emin,emax,1.0,delower,deupper)+\
                 contrib.format(2,vector_to_string(sB2-c),\
                                vector_to_string(xaxiss),\
                                vector_to_string(zaxis),'2s+0',1.0)+\
                 contrib.format(2,vector_to_string(sB2-c),\
                                vector_to_string(xaxisp),\
                                vector_to_string(zaxis),'2p+1',\
                                np.sqrt(2))+\
                 contrib.format(3,vector_to_string(sB3-c),\
                                vector_to_string(xaxiss),\
                                vector_to_string(zaxis),'2s+0',1.0*fac)+\
                 contrib.format(3,vector_to_string(sB3-c),\
                                vector_to_string(-xaxisp),\
                                vector_to_string(zaxis),'2p+1',\
                                np.sqrt(2)*fac)
            xaxisp=xaxisp.dot(C3.T)
            sB3=(sB3-sB2).dot(C3.T)+sB2
            wandefs+=txt
            #print txt


    

    with open('=.wandef','w') as f:
        f.write('{0}\n{1}\n{2}'.format(wandefheader,'-'*72,wandefs))


    
    

    return


# ===================================================================
# ===================================================================
# ===================================================================
# ===================================================================
if __name__ == '__main__':
    main()
