# -- mode: PYTHON --

def setWeight(gr,name,fill,width,color):
    w=gr.W[name] 
    w.on()
    w.style='o'
    w.skip=4
    w.fill=fill
    w.linewidth=width
    w.color=color
    return

killall()

g=G[1]
g.pointsizescale=1.5


ret=g.read('bandweight','+bweights')
gr=ret[0].group
gr.weightfactor=1
gr.showweightsinlegend=0
gr.weightstyle='connected'
gr.showinlegend=1
gr.legend='Spin $arrowup'
gr.W[1].off()
setWeight(gr,'Cu(002)3d-2',1,1.5,0xaa0000)
setWeight(gr,'Cu(002)3d-1',1,1.5,0xaa00)
setWeight(gr,'Cu(002)3d+0',1,1.5,0xee)
setWeight(gr,'Cu(002)3d+1',1,1.5,0xe5e500)
setWeight(gr,'Cu(002)3d+2',1,1.5,0xff00ff)

gr=ret[1].group
gr.weightfactor=1.
gr.showweightsinlegend=0
gr.weightstyle='individual'
gr.showinlegend=1
gr.legend='Spin $arrowdown'
gr.W[1].off()
setWeight(gr,'Cu(002)3d-2',0,1.5,0xaa0000)
setWeight(gr,'Cu(002)3d-1',0,1.5,0xaa00)
setWeight(gr,'Cu(002)3d+0',0,1.5,0xee)
setWeight(gr,'Cu(002)3d+1',0,1.5,0xe5e500)
setWeight(gr,'Cu(002)3d+2',0,1.2,0xff00ff)

Legend(1).on()\
  .setText(font=FontStyle(size=12,subscriptscale=0.75,color=0x0),
    linespacing=0.1)\
  .setSymbol(spacing=0.5,width=3)\
  .setFrame(Frame(active=1,borderspacing=0.6,
      rim=LineStyle(style='solid',width=1,color=0x0,extracolor=True),
      fill=FillStyle(active=True,color=0xffffff,extracolor=True)))\
  .setGeometry(position=(0.98,0.02),origin=(1,0))

g.title.text='CaCuO$_2$.'

printto('fatbands.png')