# -- mode: PYTHON --
#============================================================
def load(g,fname,col,name):
    ret=g.read('xny',fname)[0]
    gr=ret.group
    s1=ret.sets[0] # spin up
    s2=ret.sets[1] # spin down
    # form sum up+down (down is negative in the file-> minus)
    s1.y-=s2.y
    # remove down-set
    del gr.S[s2.id]
    s1.line.color=col
    s1.legend=name
    return s1

killall()



# load dos
g=G[1]
sB=load(g,'+bdos/+bdos.b001',0xcc0000,'DOS bonding')
sAB=load(g,'+bdos/+bdos.b002',0xcc00,'DOS anti-bonding')

# append new set 
sI=sAB.group.S.new(sB)
# subtract the two dos
sI.y-=sAB.y
# idos
sI.integrate()
sI.legend='excess bonding electrons'
sI.line.color=0xff



sI.graph.title.off()
sI.graph.xaxislabel.text='energy [eV]'
sI.graph.yaxislabel.text='DOS/IDOS'

# inserted from menu

sI.graph.usertics.on().append(Tic(type='xmajor',position=0,label='',
    ticside='Normal',labelside='Normal',length=1,labeloffset=0.03,
    line=LineStyle(style='dash',width=1,color=0x0,extracolor=True)))

Line(1,1).on().setName('')\
 .setGeometry(startat=(5.53454,1.07843),endat=(0.657589,0.984776),system='World')\
 .setLine(capat='None',style=LineStyle(style='solid',width=1,color=0x0,extracolor=True))\
 .setArrow(at='End',style='Closed',size=16,sharpness=2,
  fill=FillStyle(active=False,color=0x0,extracolor=True))


Legend(1).on()\
  .setText(font=FontStyle(size=12,subscriptscale=0.75,color=0x0),
    linespacing=0.2)\
  .setSymbol(spacing=0.5,width=1)\
  .setFrame(Frame(active=0,borderspacing=0.3,
      rim=LineStyle(style='solid',width=1,color=0x0,extracolor=True),
      fill=FillStyle(active=True,color=0xffffff,extracolor=True)))\
  .setGeometry(position=(0.408076,0.0530222),origin=(1,0))

TextBox(1,1).on()\
  .setText("0.5 bonding electron",
    font=FontStyle(size=16,subscriptscale=0.75,color=0x0))\
  .setFrame(Frame(active=0,borderspacing=0.2,
    rim=LineStyle(style='solid',width=1,color=0x0,extracolor=True),
    fill=FillStyle(active=True,color=0xffffff,extracolor=True)))\
  .setGeometry(system='View',position=(0.68,0.121081),angle=0,
    origin=(0,0),  restriction=None,offsets=[])


arrange(paperwidth=600,Nx=1,leftgap=0.15,rightgap=0.05,
    hgap=0.1,Ny=1,topgap=0.05,bottomgap=0.19,vgap=0.1,
    aspectratio=1.48292, commonxaxis=True,commonyaxis=True,
    commontitle=True)

printto('bond.png',dpi=150)

