#! /usr/bin/env python


import sys

# If your pyfplo is not found you could also
# explicitly specify the pyfplo version path:
#sys.path.insert(0,"/home/magru/FPLO/FPLO15.02-50/PYTHON/doc");

import numpy as np
import pyfplo.slabify as sla


print( '\npyfplo version=: {0}\nfrom: {1}\n'.format(sla.version,sla.__file__))
# protect against wrong version
#if fedit.version!='15.02': raise RuntimeError('pyfplo version is incorrect.')


# ===================================================================
# 
# ===================================================================

def work():


    hamdata='../+hamdata'
    
    s=sla.Slabify()
    s.object='3d'
    s.printStructureSettings()
    s.prepare(hamdata)
    
    bp=sla.BandPlot()
    bp.points=[
        ["$~G",[0,0,0]],
        ["H",[0,1,0]],
        ["N",[1./2,1./2,0]],
        ["$~G",[0,0,0]],
    ]
    bp.ndiv=150
    bp.calculateBandPlotMesh(s.dirname)
    bp.on()
    
    Ne=200
    Nkz=100

    ec=sla.EnergyContour(Ne,-13,5)
    print( ec)
    
    s.calculateBulkProjectedEDC(bp,ec,[0,0,1],nz=Nkz)

    Nk=50
    fso=sla.FermiSurfaceOptions()
    fso.setMesh(Nk,[-1,1],Nk,[-1,1])
    fso.setPlane([1,0,0],[0,1,0],[0,0,0])
    fso.fermienergyim=2./Nk*10
    
    
    # now make projected fermi surfaces
    s.calculateBulkProjectedFS(fso,zaxis=[0,0,1],nz=Nkz)
    
    
# ===================================================================
# 
# ===================================================================


if __name__ == '__main__':

    work()

