#! /usr/bin/env python


import sys

# If your pyfplo is not found you could also
# explicitly specify the pyfplo version path:
#sys.path.insert(0,"/home/magru/FPLO/FPLO15.02-50/PYTHON/doc");

import numpy as np
import pyfplo.slabify as sla


print( '\npyfplo version=: {0}\nfrom: {1}\n'.format(sla.version,sla.__file__))
# protect against wrong version
#if fedit.version!='15.02': raise RuntimeError('pyfplo version is incorrect.')


# ===================================================================
# 
# ===================================================================

def work():


    hamdata='../+hamdata'
    
    s=sla.Slabify()
    s.object='3d'
    s.enlarge=np.array([[1,0,0],[0,1,0],[0,0,1]])
    s.printStructureSettings()
    s.prepare(hamdata)
    

    fso=sla.FermiSurfaceOptions()
    fso.setMesh(200,[-2,2],200,[-2,2])
    fso.setPlane(xaxis=[1,0,0],yaxis=[0,1,0],origin=[0,0,0])
    fso.fermienergy=0.

    wds=sla.WeightDefinitions()
    wds.add(name='s').addAtoms(atom='Fe',sites=[1],orbitals=['4s'],spin='both')
    wds.add(name='xy').addAtoms(atom='Fe',sites=[1],orbitals=['3d-2'],spin='both')
    wds.add(name='yz').addAtoms(atom='Fe',sites=[1],orbitals=['3d-1'],spin='both')
    wds.add(name='z2').addAtoms(atom='Fe',sites=[1],orbitals=['3d+0'],spin='both')
    wds.add(name='xz').addAtoms(atom='Fe',sites=[1],orbitals=['3d+1'],spin='both')
    wds.add(name='x2-y2').addAtoms(atom='Fe',sites=[1],orbitals=['3d+2'],spin='both')

    s.calculateFermiSurfaceCuts(fso,wds=wds,forcerecalculation=False);


# ===================================================================
# 
# ===================================================================


if __name__ == '__main__':

    work()

