#! /usr/bin/env python

import sys
import numpy as np
import pyfplo.wanniertools as wt



# ===================================================================
def work():
    s=np.sqrt(3.)/2.

    # lattice constants in Bohr radii
    a0=5.816577012730269
    c0=6.712307195977232

    # lattice vectors
    A=np.matrix([[a0*s,-a0*0.5,0],[0,a0,0,],[0,0,c0]],dtype='float')

    # operations
    C6=np.matrix([[0.5,-s,0],[s,0.5,0,],[0,0,1]],dtype='float')
    C3=C6.dot(C6)
    C2_90=np.matrix([[-1,0,0],[0,1,0,],[0,0,-1]],dtype='float')
    s_0=np.matrix([[-1,0,0],[0,1,0,],[0,0,1]],dtype='float')
    
    # sites
    sB2=np.matrix([1./3,2./3,0.5],dtype='float').dot(A)
    sB3=sB2.dot(C6)




    emin=-13
    emax=-5
    delower=1
    deupper=1

    
    xaxiss=np.matrix([1,0,0],dtype='float')

    wdc=wt.WanDefCreator(rcutoff=25,wftol=0.001,coeffformat='bin',
                 wfgridbasis='conv',wfgridsubdiv=[30,30,30],
                 wfgriddirections=[[2,0,0],[0,2,0],[0,0,2]],
                 wfgridorigin=None,savespininfo=False,keeprunning=True)

    wandefs=''
    for fac in range(1,-3,-2):
        sB3=sB2.dot(C6)
        xaxisp=xaxiss.dot(C3.T)
        for i in range(1,4):

            c=(sB2+sB3)*0.5
            
            if fac>0:
                nameb='B'
                onoff=1
                emin=-13
                emax=-12
                delower=0.01
                deupper=7
            else:
                nameb='AB'
                onoff=0
                emin=8
                emax=8.1
                delower=8
                deupper=10

            wdc.add(wt.Wandef(
                'B {1}sp{0} '.format(i,nameb),
                emin=emin,emax=emax,de=1.0,delower=delower,deupper=deupper,onoff=onoff)
                .addContrib(site=2,orb='2s+0',fac=1.0,difvec=sB2-c,xaxis=xaxiss)
                .addContrib(site=2,orb='2p+1',fac=np.sqrt(2),difvec=sB2-c,xaxis=xaxisp)
                .addContrib(site=3,orb='2s+0',fac=fac,difvec=sB3-c,xaxis=xaxiss)
                .addContrib(site=3,orb='2p+1',fac=np.sqrt(2)*fac,difvec=sB3-c,xaxis=-xaxisp)
            )
            xaxisp=xaxisp.dot(C3.T)
            sB3=(sB3-sB2).dot(C3.T)+sB2

    wdc.writeFile()
    return


# ===================================================================
# ===================================================================
# ===================================================================
# ===================================================================
if __name__ == '__main__':
    
    work()
