# -- mode: PYTHON --
import numpy as np


#============================================================
def readdos(g,fname,leg,col=0x0,wid=1):
    gr=g.read('xny',fname)[0].group
    s=gr.S[1]
    x=np.array(s.x); s.x=s.y; s.y=x # swap x and y
    s.legend=leg
    s.line.color=col
    s.line.width=wid


killall()
# read bands
g=G[1]
gr=g.read('band','+band')[0].group
gr.line=LineStyle(style='solid',width=1,color=0x0,extracolor=True)
g.title.off()
g.legend.off()
g.world.y=[-5,5]
g.yaxislabel.restriction=('y',0)

# read DOS
g=G[2].on()
readdos(g,'+dos/+dos.total','total',0x0,1.5)
readdos(g,'+dos/+dos.sort001','Sn',0xaa0000)
readdos(g,'+dos/+dos.sort002','Te',0x00aa00)

g.title.off()
Legend(2).on()\
  .setText(font=FontStyle(size=12,subscriptscale=0.75,color=0x0),
    linespacing=0.)\
  .setSymbol(spacing=0.5,width=1)\
  .setFrame(Frame(active=0,borderspacing=0.8,
      rim=LineStyle(style='solid',width=1,color=0x0,extracolor=True),
      fill=FillStyle(active=True,color=0xffffff,extracolor=True)))\
  .setGeometry(position=(1.03,0.02),origin=(1,0))

g.xaxislabel.text='DOS [states/eV]'
g.xaxislabel.restriction=('y',0)



# adjust commen properties
g.yaxislabel.off()
g.ytics.labels.side='none'
g.usertics.new()
g.usertics[0]=UserTics(1)[0]
UserTics(1)[0].label=''
g.world.y=G[1].world.y
g.autoscale('x')




# setup graph geometry
y0=0.03 # top gap
h=0.8  # height of graphs
w1=0.57 # width of band graph
lgap=0.13 # left gap
gap=0.05  # middle gap
rgap=0.05 # right gap

x0=lgap
w2=1-(x0+w1+gap+rgap)
x1=x0+w1+gap
View(1).setGeometry(x0,y0,w1,h)
View(2).setGeometry(x1,y0,w2,h)

# set point/text scale
G[1].pointsizescale=1.2
G[2].pointsizescale=1.2

#
printto('banddos.png')
