#! /usr/bin/env python
# ===================================================================
# file:   fromcif.py
# author: k.koepernik@ifw-dresden.de
# date:   22 Mar 2018
from __future__ import print_function
import sys
import pyfplo.fploio as fploio
import pyfplo.fedit as fedit

# ===================================================================
# 
# ===================================================================
def work(mode='raw',detsym=False):

    
    print( '\nThis example shows how to import cif files.')

    whtol=1e-4 if mode=='smoothed' else  1e-6 
    
    # Create FPLOInput object and read =.in or create new parser
    # content if =.in does not exist.
    fio=fploio.FPLOInput('=.in')
    # read cif file into parser
    fio.structureFromCIFFile('RuW.cif',wyckofftolerance=whtol,
                             determinesymmetry=detsym)
    # write =.in 
    fio.writeFile("=.in")

    # here we have  =.in with the structure from the cif file

    
    # use fedit to set further input
    fed=fedit.Fedit()
    fed.iteration(n=100)
    fed.bzintegration(nxyz=[12,12,6])
    fed.pipeFedit()
    

    print ('\n\nNow we have read the raw cif content as is,'+
           ' which results in \n'+
           'the following symmetry settings:\n\n')

    printsettings()
    
    
    return

# ===================================================================
# 
# ===================================================================

def printsettings():
    fio=fploio.FPLOInput('=.in')
    par=fio.parser()
    d=par()
    print( 'spacegroup number : ',d('spacegroup.number').S)
    print( 'spacegroup setting: ',d('spacegroup.setting').S)
    print( 'lattice constants : ',d('lattice_constants').listS)
    print( 'axis angle        : ',d('axis_angles').listS)
    dw=d('wyckoff_positions')
    print( 'Wyckoff positions: ',dw.size())
    for i in range(dw.size()):
        taus=dw[i]('tau').listS
        print( '{0:>2s} {1:>20s} {2:>20s} {3:>20s}'
            .format(dw[i]('element').S,taus[0],taus[1],taus[2]))

# ===================================================================
# 
# ===================================================================

def usage():
    print( 'usage:  ',sys.argv[0],' ( raw | smoothed) [detsym]')
# ===================================================================
# 
# ===================================================================

if __name__ == '__main__':


    
    

    if len(sys.argv)<2:
        usage()
        sys.exit(0)
    mode=sys.argv[1]
    mode=mode.replace('-','')

    if not (mode=='raw' or mode=='smoothed'):
        usage()
        sys.exit(0)

    detsym=False
    if len(sys.argv)>=3:
        detsym=True

        
    work(mode,detsym)
        
    sys.exit(0)




