#! /usr/bin/env python
# ===================================================================
# file:   extended_basis.py
# author: k.koepernik@ifw-dresden.de
# date:   06 Jun 2017
from __future__ import print_function
import sys
import os
import pyfplo.fedit as fedit

print( '\npyfplo version=: {0}\nfrom: {1}\n'.format(fedit.version,fedit.__file__))
# protect against wrong version
#if fedit.version!='22.00': raise RuntimeError('pyfplo version is incorrect.')

# ===================================================================
# 
# ===================================================================
def work():
    # Get an Fedit instance:
    # We eant to change the basis in an existing =.in so recreate=False !!
    fed=fedit.Fedit(recreate=False)
    # Set extensionlevel=2 and add H-3d and f-orbital if needed and
    # leave the rest as it is:
    fed.basis(extensionlevel=2,add3d=True,addf=True)
    # If the rest of the basis menu should be reset to default use:
    fed.basis(extensionlevel=2,add3d=True,addf=True,
              multicore=[],multisemicore=[],
              core4f=[],core4fNoValenceF=[])
    
    fed.pipeFedit(prot=True)
    return

# ===================================================================
# 
# ===================================================================

if __name__ == '__main__':

    work()
    
    sys.exit(0)




