#! /usr/bin/env python
# ===================================================================
# file:   simple.py
# author: k.koepernik@ifw-dresden.de
# date:   06 Jun 2017
from __future__ import print_function
import sys
import os
import pyfplo.fedit as fedit

print( '\npyfplo version=: {0}\nfrom: {1}\n'.format(fedit.version,fedit.__file__))
# protect against wrong version
#if fedit.version!='22.00': raise RuntimeError('pyfplo version is incorrect.')

# ===================================================================
# 
# ===================================================================
def work():

    # rm old files
    os.system('rm +dos* +band +bweigh*')

    # get a Fedit instance
    fed=fedit.Fedit(recreate=False)
    # set  some stuff for the SCF run
    fed.bzintegration(nxyz=[6,6,6])

    # switch off bandplot (if already set) so that we do not
    # calculate unnecessary stuff during self consistency
    fed.bandplot(active=False)
    # write  input file
    fed.pipeFedit()

    # run fplo (SCF)
    os.system(fedit.fploExecutable()+"|tee outscf")


    # now we re-run for bandplot.
    # Note that we use the Fedit() from before
    fed.bandplot(active=True)
    fed.pipeFedit()
    os.system(fedit.fploExecutable()+"|tee outb")

    
    return

# ===================================================================
# 
# ===================================================================

if __name__ == '__main__':

    work()
    
    sys.exit(0)




