#! /usr/bin/env python
# ===================================================================
# file:   bandplot.py
# author: k.koepernik@ifw-dresden.de
# date:   19 Apr 2017
from __future__ import print_function
import sys
import pyfplo.fploio as fploio
# ===================================================================
# 
# ===================================================================
def work():


    print( '\nThis example shows how to parse =.in files.\n')
    
    p=fploio.INParser()
    p.parseFile('=.in')
    d=p()

    print( 'sorts:',d('nsort').L)
    print( 'lattice constants:',d('lattice_constants').listD)
    print( 'or\nlattice constants:',d('lattice_constants').listS)
    print( '\nWyckoff positions')
    dw=d('wyckoff_positions')
    for i in range(dw.size()):
        dd=dw[i]
        print( dd('element').S,dd('tau').listS)


    print( '\nAlternative way of doing it')
    for i in range(dw.size()):
        dd=dw[i]
        print( dd('element').S,dd('tau')[0].S,dd('tau')[1].S,dd('tau')[2].S)
    

    print( '\nYet another way')
    for i in range(dw.size()):
        dd=dw[i]
        print( dd('element').S,dd('tau[0]').S,dd('tau[1]').S,dd('tau[2]').S)

    print( '\nsingle shot')
    print( d('wyckoff_positions[0].element').S,
        d('wyckoff_positions[0].tau').listS)

    print( '\noptions')
    do=d('options')
    for i in range(do.size()):
        print( do[i].S,)
        if ((i+1)%4)==0: print()
    print()
    print( '\nsetting CALC_PLASMON_FREQ and CALC_DOS')
    do['CALC_PLASMON_FREQ'].L=True
    do['CALC_DOS'].L=True
    print( '\nwhich now are',bool(do['CALC_PLASMON_FREQ'].L)
        ,'and',bool(do['CALC_DOS'].L))
    print( '\nhave another look at options')
    do=d('options')
    for i in range(do.size()):
        print( do[i].S,)
        if (i%4)==0: print()
    print()
    
    
    
    return

# ===================================================================
# 
# ===================================================================

if __name__ == '__main__':

    work()
    
    sys.exit(0)




