#! /usr/bin/env python3
# ===================================================================
# file:   g.py
# author: k.koepernik@ifw-dresden.de
# date:   22 Jun 2022

from __future__ import print_function
import os
import pyfplo.fploio as fploio

print( '\npyfplo version=: {0}\nfrom: {1}\n'.format(fploio.version,fploio.__file__))
# protect against wrong version
#if fploio.version!='22.00': raise RuntimeError('pyfplo version is incorrect.')

og=fploio.OutGrep('out')
si=og.sites()

with open('res','w') as fh:
    res=og.grep('it')
    fh.write('# step last_dev\n')
    for i,r in enumerate(res):
        fh.write('{} {}\n'.format(i,r))
    fh.write('\n')

    res=og.grep('EE')
    fh.write('# step Etot\n')
    for i,r in enumerate(res):
        fh.write('{} {}\n'.format(i,r))
    fh.write('\n')

    res=og.grep('gap')
    E0=float(res[0])
    fh.write('# step gap\n')
    for i,r in enumerate(res):
        fh.write('{} {}\n'.format(i,r))
    fh.write('\n')

with open('resspins','w') as fh:

    for i,s in enumerate(si):
        site=i+1
        res=og.grep('SSat',site)
        fh.write('# step \'atom spin {}{}\'\n'.format(s.element,site))
        for it,r in enumerate(res):
            fh.write('{} {}\n'.format(it,r))
        fh.write('\n')
os.system('xfbp grepiterationprogress.xpy')
