#! /usr/bin/env python
# ===================================================================
# file:   addwei.py
# author: k.koepernik@ifw-dresden.de
# date:   28 Jul 2017
from __future__ import print_function
import sys



# If your pyfplo is not found you could also
# explicitly specify the pyfplo version path:
#sys.path.insert(0,"/home/magru/FPLO/FPLO22.00-62/PYTHON/doc");

import numpy as np
import pyfplo.slabify as sla


print( '\npyfplo version=: {0}\nfrom: {1}\n'.format(sla.version,sla.__file__))
# protect against wrong version
#if fedit.version!='22.00': raise RuntimeError('pyfplo version is incorrect.')


# ===================================================================
# 
# ===================================================================
def work():


    # define some weights for addweight
    wds=sla.WeightDefinitions()
    w=wds.add('Bi').addAtoms('Bi',[1,2],['6s','6p'],spin='b')
    w=wds.add('Bip').addAtoms('Bi',[1,2],['6p'],spin='b')
    w=wds.add('Se').addAtoms('Se',[3,4,5],['4s','4p'],spin='b')
    w=wds.add('Sep').addAtoms('Se',[3,4,5],['4p'],spin='b')

    
    # read a bandweights file 
    bw=sla.BandWeights("+bweightslms")
    # and add weights and write to +bwsum
    bw.addWeights(wds,'+bwsumlms',vlevel=sla.Vlevel.All)



    return

# ===================================================================
# 
# ===================================================================

if __name__ == '__main__':

    work()
    
    sys.exit(0)




