#! /usr/bin/env python

from __future__ import print_function
import sys

# If your pyfplo is not found you could also
# explicitly specify the pyfplo version path:
#sys.path.insert(0,"/home/magru/FPLO/FPLO22.00-62/PYTHON/doc");

import numpy as np
import pyfplo.slabify as sla


print( '\npyfplo version=: {0}\nfrom: {1}\n'.format(sla.version,sla.__file__))
# protect against wrong version
#if fedit.version!='22.00': raise RuntimeError('pyfplo version is incorrect.')


# ===================================================================
# 
# ===================================================================

def work():


    hamdata='../../+hamdata'
    
    s=sla.Slabify()
    s.object='3d'
    s.enlarge=np.array([[1,0,0],[0,1,0],[0,0,1]])
    s.printStructureSettings()
    s.prepare(hamdata)
    

    fso=sla.FermiSurfaceOptions()
    fso.setMesh(200,[-2,2],200,[-2,2])
    fso.setPlane(xaxis=[1,0,0],yaxis=[0,1,0],origin=[0,0,0])
    fso.fermienergy=0.

    wds=sla.WeightDefinitions()
    wds.add(name='s').addAtoms(atom='Al',sites=[1],orbitals=['3s'],fac=1)
    wds.add(name='y').addAtoms(atom='Al',sites=[1],orbitals=['3p-1'],fac=1)
    wds.add(name='z').addAtoms(atom='Al',sites=[1],orbitals=['3p+0'],fac=1)
    wds.add(name='x').addAtoms(atom='Al',sites=[1],orbitals=['3p+1'],fac=1)

    s.calculateFermiSurfaceCuts(fso,wds=wds,forcerecalculation=True);


# ===================================================================
# 
# ===================================================================


if __name__ == '__main__':

    work()

