#! /usr/bin/env python
# ===================================================================
# file:   bhz.py
# author: k.koepernik@ifw-dresden.de
# date:   05 Jul 2017
from __future__ import print_function
import sys
import numpy as np


# ===================================================================
# 
# ===================================================================


def BHZhamiltonian(dir,A,B,C,D,M,de,a=1,k=[0,0,0],makehamdata=False):

    H=np.zeros((4,4),dtype='complex')


    
    e=(C-4*D/a**2) + 2*D/a**2*(np.cos(k[0]*a)+np.cos(k[1]*a))
    d3=-2*B/a**2*(2.-M/(2.*B))\
        +2*B/a**2*(np.cos(k[0]*a)+np.cos(k[1]*a))
    dp=A/a*(np.sin(k[0]*a)+1.j*np.sin(k[1]*a))
    delta=de

    
    H[0,0]=e+d3
    H[1,1]=e-d3
    H[1,0]=dp
    H[0,1]=np.conj(dp)


    H[2,2]=e+d3
    H[3,3]=e-d3
    H[3,2]=-np.conj(dp)
    H[2,3]=-dp


    H[0,3]=delta
    H[1,2]=-delta
    H[2,1]=-delta
    H[3,0]=delta


    if makehamdata:
        e0=C-4*D/a**2
        t1=D/a**2
        d30=-2*B/a**2*(2.-M/(2.*B))
        d3=B/a**2
        dp=A/a/2
        
        makeHamdata(dir,a,e0,t1,d30,d3,de,dp)
    

    return H
    

# ===================================================================
# 
# ===================================================================


def makeHamdata(dir,a,e0,t1,d30,d3,de,dp):

    with open(dir+'/+hamdata','w') as f:
        f.write('''
RTG:
F
lattice_vectors:
{0} 0 0
0 {0} 0
0  0  {1}
centering:
1 0 0
0 1 0
0 0 1
fullrelativistic:
t
nwan:
4
nspin:
1
wannames:
W1
W2
W3
W4
wancenters:
0 0 0
0 0 0
0 0 0
0 0 0
spin:
1
Tij, Hij:
1 1
0 0 0 {2} 0
{0} 0 0 {3} 0
-{0} 0 0 {3} 0
0 {0}  0 {3} 0
0 -{0}  0 {3} 0
end Tij, Hij:
Tij, Hij:
2 2
0 0 0 {4} 0
{0} 0 0 {5} 0
-{0} 0 0 {5} 0
0 {0}  0 {5} 0
0 -{0}  0 {5} 0
end Tij, Hij:
Tij, Hij:
3 3
0 0 0 {2} 0
{0} 0 0 {3} 0
-{0} 0 0 {3} 0
0 {0}  0 {3} 0
0 -{0}  0 {3} 0
end Tij, Hij:
Tij, Hij:
4 4
0 0 0 {4} 0
{0} 0 0 {5} 0
-{0} 0 0 {5} 0
0 {0}  0 {5} 0
0 -{0}  0 {5} 0
end Tij, Hij:
Tij, Hij:
1 4
0 0 0 {6} 0
end Tij, Hij:
Tij, Hij:
2 3
0 0 0 {7} 0
end Tij, Hij:
Tij, Hij:
3 2
0 0 0 {7} 0
end Tij, Hij:
Tij, Hij:
4 1
0 0 0 {6} 0
end Tij, Hij:
Tij, Hij:
2 1
{0} 0 0 0 {9} 
-{0} 0 0 0 {8} 
0 {0} 0  {9} 0
0 -{0}  0  {8} 0 
end Tij, Hij:
Tij, Hij:
1 2
{0} 0 0 0 {9} 
-{0} 0 0 0 {8} 
0 {0} 0  {8} 0
0 -{0}  0  {9} 0 
end Tij, Hij:
Tij, Hij:
4 3 
{0} 0 0 0 {8} 
-{0} 0 0 0 {9} 
0 {0} 0  {9} 0
0 -{0} 0  {8}  0
end Tij, Hij:
Tij, Hij:
3 4 
{0} 0 0 0 {8} 
-{0} 0 0 0 {9} 
0 {0} 0  {8} 0
0 -{0} 0  {9}  0
end Tij, Hij:
end spin:

        '''.format(a,10*a,e0+d30,t1+d3,e0-d30,t1-d3,de,-de,dp,-dp))

# ===================================================================
# 
# ===================================================================

if __name__ == '__main__':

    a=5
    
    # trivial phase
    BHZhamiltonian('I',A=-14.48,B=-18.0,C=-0.018,D=-0.594,
                   M=2.766,de=1.2,a=a,makehamdata=True)
    # TI phase
    BHZhamiltonian('TI',A=-13.68,B=-16.9,C=-0.0263,D=-0.514,
                   M=-6,de=1.2,a=a,makehamdata=True)
    




