#! /usr/bin/env python 

from __future__ import print_function
import sys

# If your pyfplo is not found you could also
# explicitly specify the pyfplo version path:
#sys.path.insert(0,"/home/magru/FPLO/FPLO22.00-62/PYTHON/doc");

import numpy as np
import pyfplo.slabify as sla
import pyfplo.fploio as fploio


print( '\npyfplo version=: {0}\nfrom: {1}\n'.format(sla.version,sla.__file__))
# protect against wrong version
#if fedit.version!='22.00': raise RuntimeError('pyfplo version is incorrect.')


# ===================================================================
# 
# ===================================================================

def work():


    p=fploio.INParser()
    p.parseFile('../../=.in')
    d=p()('special_sympoints')
    l=[]
    for i in range(d.size()):
        l.append([ d[i]('label').S,d[i]('kpoint').listD])
    

    
    hamdata='../../+hamdata'
    
    s=sla.Slabify()
    s.object='3d'
    s.printStructureSettings()
    s.prepare(hamdata)

    
    bp=sla.BandPlot()
    bp.points=l
    bp.calculateBandPlotMesh(s.dirname)



    # global B-field=1.1eV for all orbitals
    s.bfield.setGlobalField([0,0,1.1])
    s.calculateBandStructure(bp,suffix='_global')
    


    # local B-field setup: B-3d=1  and B_4sp=0.2
    orb3d=list(map(lambda x: 1 if '3d' in x else 0 ,s.orbitalNames()))
    orb4sp=list(map(lambda x: 1 if ('4s' in x or '4p' in x) else 0 ,
                    s.orbitalNames()))
    Bd=1.1
    Bsp=0.2
    
    B=[
        [ orb3d ,[0,0,Bd ]],
        [ orb4sp,[0,0,Bsp]],
        ]

    
    s.bfield.setGlobalField([0,0,0])
    s.bfield.setLocalFields(B)
    s.calculateBandStructure(bp,suffix='_local')



    



# ===================================================================
# 
# ===================================================================


if __name__ == '__main__':

    work()

