#! /usr/bin/env python

from __future__ import print_function
import sys

# If your pyfplo is not found you could also
# explicitly specify the pyfplo version path:
#sys.path.insert(0,"/home/magru/FPLO/FPLO22.00-62/PYTHON/doc");

import numpy as np
import numpy.linalg as LA
import pyfplo.slabify as sla


print( '\npyfplo version=: {0}\nfrom: {1}\n'.format(sla.version,sla.__file__))
# protect against wrong version
#if fedit.version!='22.00': raise RuntimeError('pyfplo version is incorrect.')


# ===================================================================
# 
# ===================================================================

def work():


    hamdata='../../+hamdata'
    
    s=sla.Slabify()
    s.object='semislab'
    s.zaxis=[0,0,-1]
    s.numberoflayers=1
    s.anchor=0.001
    s.printStructureSettings()
    s.prepare(hamdata)

    # the conventional cell
    A=s.hamdataCCell()
    # its lattice parameters
    a=LA.norm(A[:,0])
    b=LA.norm(A[:,1])
    aob=a/b
    
    Nk=200
    fso=sla.FermiSurfaceOptions()
    fso.setMesh(Nk,[0,0.5],Nk,[0,0.5*aob])
    fso.setPlane([1,0,0],[0,1,0],[0,0,0])
    fso.fermienergy=-0.02
    fso.fermienergyim=1./Nk*1.
    print( fso)
    
    s.calculateFermiSurfaceSpectralDensity(fso,penetrationdepth=-1.)
    
# ===================================================================
# 
# ===================================================================


if __name__ == '__main__':

    work()

