#! /usr/bin/env python
# ===================================================================
# file:   densplotfile.py
# author: k.koepernik@ifw-dresden.de
# date:   12 Jun 2020

from __future__ import print_function
import sys,os

# If your pyfplo is not found you could also
# explicitly specify the pyfplo version path:
#sys.path.insert(0,"/home/magru/FPLO/FPLO22.00-62/PYTHON/doc");

import pyfplo.slabify as sla
import numpy as np

print( '\npyfplo version=: {0}\nfrom: {1}\n'.format(sla.version,sla.__file__))
# protect against wrong version
#if fedit.version!='22.00': raise RuntimeError('pyfplo version is incorrect.')


# ===================================================================
# 
# ===================================================================
def work():

    sq2o2=np.sqrt(0.5)
    fso=sla.FermiSurfaceOptions()
    fso.setMesh(200,[-sq2o2,sq2o2],200,[-sq2o2,sq2o2])
    fso.setPlane(xaxis=[1,1,0],yaxis=[-1,1,0],origin=[0.,0.,0])
    fso.fermienergy=0

    mesh=fso.mesh(1.)
    
    with fso.openDensPlotFile('+c',0,
                              plotorigin=[0,0],
                              plotxaxis=[sq2o2,sq2o2],
                              plotyaxis=[-sq2o2,sq2o2],
                              progress='curvature') as fw:
        
        for k in mesh:
            fw.write([np.cos((k[0])*2*np.pi)+np.cos((k[1])*2*np.pi)])

    with open('c.xpy','w') as f:
        f.write('''
# -- mode: PYTHON --
killall()
g=G[1]
ret=g.read('xynz','+c.spin1')[0]
ret.sets[0].colormap='rainbow'
g.autoscale()
arrange(aspectratio=1)

''')
    os.system('xfbp c.xpy')
    return

# ===================================================================
# 
# ===================================================================

if __name__ == '__main__':

    work()
    
    sys.exit(0)




