#! /usr/bin/env python

from __future__ import print_function
import sys

# If your pyfplo is not found you could also
# explicitly specify the pyfplo version path:
#sys.path.insert(0,"/home/magru/FPLO/FPLO22.00-62/PYTHON/doc");

import numpy as np
import pyfplo.slabify as sla
import pyfplo.fploio as fploio


print( '\npyfplo version=: {0}\nfrom: {1}\n'.format(sla.version,sla.__file__))
# protect against wrong version
#if fedit.version!='22.00': raise RuntimeError('pyfplo version is incorrect.')


# ===================================================================
# 
# ===================================================================

def work():

    p=fploio.INParser()
    p.parseFile('../../=.in')
    d=p()('special_sympoints')
    l=[]
    for i in range(d.size()):
        l.append([ d[i]('label').S,d[i]('kpoint').listD])
    

    hamdata='../../+hamdata'
    
    s=sla.Slabify()
    s.object='3d'
    s.printStructureSettings()
    s.prepare(hamdata)
    
    bp=sla.BandPlot()
    bp.points=l
    bp.ndiv=150
    bp.calculateBandPlotMesh(s.dirname)
    bp.on()
    
    Ne=200
    Nkz=100

    ec=sla.EnergyContour(Ne,-21,25)



    s.calculateBulkProjectedEDC(bp,ec,[0,0,1],nz=Nkz)

    Nk=100
    fso=sla.FermiSurfaceOptions()
    fso.setMesh(Nk,[-1,1],Nk,[-1,1])
    fso.setPlane([1,0,0],[0,1,0],[0,0,0])
    fso.fermienergyim=2./Nk*10
    fso.on()
    
    # now make projected fermi surfaces
    s.calculateBulkProjectedFS(fso,zaxis=[0,0,1],nz=Nkz)
    

# ===================================================================
# 
# ===================================================================


if __name__ == '__main__':

    work()

