#! /usr/bin/env python
from __future__ import print_function
import sys

# If your pyfplo is not found you could also
# explicitly specify the pyfplo version path:
#sys.path.insert(0,"/home/magru/FPLO/FPLO22.00-62/PYTHON/doc");

import numpy as np
import pyfplo.slabify as sla


print( '\npyfplo version=: {0}\nfrom: {1}\n'.format(sla.version,sla.__file__))
# protect against wrong version
#if fedit.version!='22.00': raise RuntimeError('pyfplo version is incorrect.')


# ===================================================================
# 
# ===================================================================

def work():

    hamdata='../+hamdata'
    
    s=sla.Slabify()


    s.object='3d'
    s.printStructureSettings()

    s.prepare(hamdata)

    bp=sla.BandPlot()
    bp.points=[
        ['$~G',[0,0,0]],
        ['X',[0.5,0,0]],
        ['M',[0.5,0.5,0]],
        ['$~G',[0,0,0]],
        ]
    bp.ndiv=100
    bp.calculateBandPlotMesh(s.dirname)
    
    Ne=200
    Nkz=100

    ec=sla.EnergyContour(Ne,-15,25)
    print( ec)
    s.calculateBulkProjectedEDC(bp,ec,[0,0,1],nz=Nkz)

    
    Nk=200
    fso=sla.FermiSurfaceOptions()
    fso.setMesh(Nk,[-0.5,0.5],Nk,[-0.5,0.5]) 
    fso.setPlane([1,0,0],[0,1,0],[0,0,0])
    fso.fermienergyim=2./Nk*10

    # now make projected fermi surfaces
    s.calculateBulkProjectedFS(fso,zaxis=[0,0,1],nz=Nkz)



# ===================================================================
# 
# ===================================================================


if __name__ == '__main__':

    work()

