#! /usr/bin/env python
from __future__ import print_function
import sys

# If your pyfplo is not found you could also
# explicitly specify the pyfplo version path:
#sys.path.insert(0,"/home/magru/FPLO/FPLO22.00-62/PYTHON/doc");

import numpy as np
import pyfplo.slabify as sla


print( '\npyfplo version=: {0}\nfrom: {1}\n'.format(sla.version,sla.__file__))
# protect against wrong version
#if fedit.version!='22.00': raise RuntimeError('pyfplo version is incorrect.')


# ===================================================================
# 
# ===================================================================

def work():

    hamdata='../+hamdata'
    
    s=sla.Slabify()


    s.object='3d'
    s.printStructureSettings()

    s.prepare(hamdata)
    

    fso=sla.FermiSurfaceOptions()
    fso.setMesh(100,[-0.5,0.5],100,[-0.5,0.5]) 

    n=10
    for ikz in range(0,n+1):
        kz=ikz*0.5/n
        fso.setPlane([1,0,0],[0,1,0],[0,0,kz])
        fso.fermienergy=0
        suffix='_kz={0:05.2f}'.format(kz)
        # we need to set forcerecalculation=True since
        # the k-plane changes with every loop
        s.calculateFermiSurfaceCuts(fso,suffix=suffix,forcerecalculation=True);

    
        fso.fermienergy=-3
        suffix='_kz={0:05.2f}_ef={1:05.2f}'.format(kz,fso.fermienergy)
        # Now we do NOT need to set forcerecalculation=True since
        # only the Fermi energy changed.
        # The actual example is so fast that you do not see the impact.
        s.calculateFermiSurfaceCuts(fso,suffix=suffix,forcerecalculation=False);

    


# ===================================================================
# 
# ===================================================================


if __name__ == '__main__':

    work()

